Attribute VB_Name = "Module1"
Option Explicit

Global Const RFC_CHAR = 0
Rem Const gTYPDATE  = 1       'RFC_DATE       STRING $        date (YYYYMMDD)
Rem Const gTYPP     = 2       'RFC_BCD        STRING $        packed numbers
Rem Const gTYPTIME  = 3       'RFC_TIME       STRING $        time (HHMMSS)
Rem Const gTYPX     = 4       'RFC_BYTE       STRING $        raw data
Global Const RFC_TAB = 5        'not used here
Global Const RFC_NUM = 6
Rem Const gTYPFLOAT = 7       'RFC_FLOAT      FLOAT #         floating point
Rem Const gTYPINT   = 8       'RFC_INT        LONG &          4 byte integer
Rem Const gTYPINT2  = 9       'RFC_INT2       INTEGER %       2 byte integer
Rem Const gTYPINT1  = 10      'RFC_INT1       INTEGER %       1 byte integer
Rem Const gTYPB     = 11      'not used here
Rem Const gTYP1     = 12      'not used here
Rem Const gTYP2     = 13      'not used here


Rem RFC_MODE Rfc open modus
Rem Const RFC_MODE_R3ONLY = 0 'only for R/3 systems, any kind of user
Rem Const RFC_MODE_CPIC   = 1 'can be used for R/2, but CPIC-Users only


Global Const RFC_OK = 0
Global Const RFC_FAILURE = 1
Global Const RFC_EXCEPTION = 2
Global Const RFC_SYS_EXCEPTION = 3
Global Const RFC_CALL = 4
Global Const RFC_INTERNAL_COM = 5
Global Const RFC_CLOSED = 6
Global Const RFC_RETRY = 7
Global Const RFC_NO_TID = 8
Global Const RFC_EXECUTED = 9

Type RFC_ERROR_INFO
  Key     As String * 33
  status  As String * 128
  MESSAGE As String * 256
  intstat As String * 128
End Type

Type RFC_ERROR_INFO_EX
    group As Long
    Key As String * 33
    MESSAGE As String * 513
End Type

Type RFC_PARAMETER
  NAME As String
  nlen As Long
  TYPE As Long
  len As Long
  addr As Long
End Type

Type RFC_TABLE
  NAME As String
  nlen As Integer
  TYPE As Integer
  leng As Integer
  ithandle As Long
  itmode As Integer
  newitab As Integer
End Type

' Allgemeine RFC-Funtionen
Declare Function RfcOpenEx Lib "librfc32.dll" (ByVal ConString As String, _
    RfcError As RFC_ERROR_INFO_EX) As Long
Declare Sub RfcClose Lib "librfc32.dll" (ByVal hRfc As Long)
Declare Function RfcLastError Lib "librfc32.dll" (RfcErrorInfo As RFC_ERROR_INFO) As Long
Declare Function RfcLastErrorEx Lib "librfc32.dll" (RfcErrorInfo As RFC_ERROR_INFO_EX) As Long


' Client Funtionen
Declare Function RfcAllocParamSpace Lib "librfc32.dll" (ByVal ExportCount As Long, _
    ByVal ImportCount As Long, ByVal TableCount As Long) As Long
    
Declare Function RfcAddExportStructure Lib "librfc32.dll" Alias "RfcAddExportParam" (ByVal hSpace As Long, _
    ByVal ParamNo As Long, ByVal ParamName As String, ByVal nlen As Long, _
    ByVal ParamType As Long, ByVal leng As Long, param As Any) As Long
    
Declare Function RfcAddExportParam Lib "librfc32.dll" (ByVal hSpace As Long, _
    ByVal ParamNo As Long, ByVal ParamName As String, ByVal nlen As Long, _
    ByVal ParamType As Long, ByVal leng As Long, ByVal param As String) As Long
    
Declare Function RfcDefineImportParam Lib "librfc32.dll" (ByVal hSpace As Long, _
    ByVal ParamNo As Long, ByVal ParamName As String, ByVal nlen As Long, _
    ByVal ParamType As Long, ByVal leng As Long) As Long
    
Declare Function RfcGetImportStructure Lib "librfc32.dll" Alias "RfcGetImportParam" (ByVal hSpace As Long, _
    ByVal ParamNo As Long, param As Any) As Long
    
Declare Function RfcGetImportParam Lib "librfc32.dll" (ByVal hSpace As Long, _
    ByVal ParamNo As Long, param As String) As Long
    
Declare Function RfcAddTable Lib "librfc32.dll" (ByVal hSpace As Long, _
    ByVal TableNo As Long, ByVal TableName As String, ByVal nlen As Long, _
    ByVal TableType As Long, ByVal leng As Long, ByVal hIT As Long) As Long
    

Declare Function RfcCallExt Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal hSpace As Long, FunctionName As String) As Long

Declare Function RfcCallReceiveEx Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal FunctionName As String, ByVal Exporting As Long, _
    Importing As RFC_PARAMETER, Importing As RFC_PARAMETER, _
    Tables As RFC_TABLE, Exception As String) As Long
    
Declare Function RfcReceiveEx Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal FunctionName As String, Exporting As RFC_PARAMETER, _
    Importing As RFC_PARAMETER, Tables As RFC_TABLE) As Long
    
Declare Function RfcReceiveExt Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal hSpace As Long, ByVal Exception As String)
    
Declare Function RfcCallReceiveExt Lib "librfc32.dll" (ByVal hRfc As Long, _
    ByVal hSpace As Long, ByVal funcname As String, _
    ByVal Exception As String) As Long
    
Declare Function RfcConvertBcdToChar Lib "librfc32.dll" (ByVal StringIn As String, _
    ByVal LenIn As Long, ByVal Decimals As Long, _
    StringOut As String, ByVal LenOut As Long) As Long
    
Declare Function RfcConvertCharToBcd Lib "librfc32.dll" (ByVal StringIn As String, _
    ByVal LenIn As Long, ByVal Decimals As Long, _
    StringOut As String, ByVal LenOut As Long) As Long
       
' Tabellen-Handling
Declare Function ItCreate Lib "librfc32.dll" (ByVal ITName As String, ByVal ItRecLen As Long, ByVal ItOccurs As Long, ByVal Reserve As Long) As Long
Declare Function ItDelete Lib "librfc32.dll" (ByVal hIT As Long) As Long
Declare Function ItGetLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long) As Long
Declare Function ItInsLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long) As Long
Declare Function ItAppLine Lib "librfc32.dll" (ByVal hIT As Long) As Long
Declare Function ItDelLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long) As Long
Declare Function ItGupLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long) As Long
Declare Function ItCpyLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long, ByVal Dest As Long) As Long
Declare Function ItFree Lib "librfc32.dll" (ByVal hIT As Long) As Long
Declare Function ItFill Lib "librfc32.dll" (ByVal hIT As Long) As Long
Declare Function ItLeng Lib "librfc32.dll" (ByVal hIT As Long) As Long
Declare Function ItPutLine Lib "librfc32.dll" (ByVal hIT As Long, ByVal ItLine As Long, itContect As Long) As Long

Public Declare Sub CopyMemoryWrite Lib "kernel32" Alias _
    "RtlMoveMemory" (ByVal Destination As Long, Source As Any, _
    ByVal length As Long)

Public Declare Sub CopyMemoryRead Lib "kernel32" Alias _
    "RtlMoveMemory" (Destination As Any, ByVal Source As Long, _
    ByVal length As Long)




Public Function ConvertBCDToDbl(BCD As String, Decimals As Long) As Double
Dim length As Long
Dim Number As String
Dim res As Double

length = Len(BCD)
Dim x As Long
For x = 1 To length
    Number = Number + Right("0" & Hex(Asc(Mid(BCD, x, 1))), 2)
Next x

res = CDec(Mid(Number, 1, Len(Number) - 1))

If Right(Number, 1) = "D" Then
    res = -1 * res
End If

ConvertBCDToDbl = res / (10 ^ Decimals)
End Function

Public Function ConvertDblToBCD(Value As Double, PackedLength As Long, Decimals As Long) As String

Value = Int(Value * 10 ^ Decimals)

Dim ValueString As String
ValueString = CStr(Value)
Dim tempString As String

If Value < 0 Then
    tempString = Chr(Val(Right(ValueString, 1)) * 16 + 13)
Else
    tempString = Chr(Val(Right(ValueString, 1)) * 16 + 12)
End If

ValueString = Mid(ValueString, 1, Len(ValueString) - 1)

If Len(ValueString) Mod 2 = 1 Then
    ValueString = "0" & ValueString
End If

Dim x As Long
Dim OneByte As String

For x = Len(ValueString) To 1 Step -2
    OneByte = Chr(Val(Mid(ValueString, x - 1, 1)) * 16 + Val(Mid(ValueString, x, 1)))
    tempString = OneByte & tempString
Next x

ConvertDblToBCD = Right(String(PackedLength, Chr(0)) & tempString, PackedLength)

End Function

